/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.gui.actions.shells.modify;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import net.nooj4nlp.controller.TextEditorShell.TextEditorShellController;
import net.nooj4nlp.engine.Constants;
import net.nooj4nlp.engine.Language;
import net.nooj4nlp.engine.Ntext;
import net.nooj4nlp.engine.TuGraph;
import net.nooj4nlp.gui.components.CursorChangeEffect;
import net.nooj4nlp.gui.components.CustomJSpinner;
import net.nooj4nlp.gui.shells.TextEditorShell;

public class UnitSelectionListener
implements CaretListener {
    private JTextPane textPane;
    private StyledDocument doc;
    private int paragraphStart;
    private String text = "";
    private String delimiter;
    private CustomJSpinner spinner;
    private TextEditorShellController controller;
    private TextEditorShell textShell;
    private int currentTUnb;
    private Ntext myText;

    public UnitSelectionListener(TextEditorShellController controller, JTextPane t) {
        this.controller = controller;
        TextEditorShell textShell = controller.getTextShell();
        this.delimiter = textShell.getText().getDelimPattern();
        this.textShell = controller.getTextShell();
        this.textPane = t;
        this.textPane.setForeground(Color.gray);
        this.spinner = textShell.getSpinner();
        this.doc = this.textPane.getStyledDocument();
        this.myText = controller.getMyText();
        Style active = this.textPane.addStyle("Active", null);
        StyleConstants.setForeground(active, Color.black);
        Style inactive = this.textPane.addStyle("Inactive", null);
        StyleConstants.setForeground(inactive, Color.gray);
        Style redStyle = this.textPane.addStyle("Red", null);
        StyleConstants.setForeground(redStyle, Color.RED);
        Style blueStyle = this.textPane.addStyle("Blue", null);
        StyleConstants.setForeground(blueStyle, Color.BLUE);
        Style greenStyle = this.textPane.addStyle("Green", null);
        StyleConstants.setForeground(greenStyle, new Color(20, 180, 62));
        Style blackStyle = this.textPane.addStyle("Black", null);
        StyleConstants.setForeground(blackStyle, Color.BLACK);
        StyleConstants.setUnderline(blackStyle, true);
        try {
            this.text = this.textPane.getDocument().getText(0, this.textPane.getDocument().getLength());
        }
        catch (BadLocationException e1) {
            e1.printStackTrace();
        }
        this.paragraphStart = 0;
        if (!this.text.equals("")) {
            int firstParagraphEnd = this.text.indexOf(this.delimiter);
            String currentParagraph = firstParagraphEnd != -1 ? this.text.substring(this.paragraphStart, firstParagraphEnd) : this.text;
            this.doc.setCharacterAttributes(0, this.text.length(), this.textPane.getStyle("Inactive"), true);
            this.doc.setCharacterAttributes(this.paragraphStart, currentParagraph.length(), this.textPane.getStyle("Active"), true);
        } else {
            String currentParagraph = "";
            this.doc.setCharacterAttributes(0, this.text.length(), this.textPane.getStyle("Inactive"), true);
            this.doc.setCharacterAttributes(this.paragraphStart, currentParagraph.length(), this.textPane.getStyle("Active"), true);
        }
        this.doc.putProperty("__EndOfLine__", "\n");
        this.currentTUnb = 1;
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        int rtbPosition = e.getDot();
        int adjuster = 0;
        for (int i = 0; i < rtbPosition; ++i) {
            if (this.text.charAt(i) != '\r') continue;
            ++adjuster;
        }
        int txtPosition = rtbPosition += adjuster;
        int newTUnb = this.locateTextUnit(txtPosition);
        if (newTUnb != this.currentTUnb) {
            this.currentTUnb = newTUnb;
            this.spinner.setValue(this.currentTUnb);
            this.controller.rtbTextUpdate(false);
            this.textPane.getCaret().setVisible(true);
        }
        if (this.textShell.getChckbxShowTextAnnotation().isSelected()) {
            this.controller.setTuGraph(this.currentTUnb);
            this.controller.getTuGraph().setNeedToBeComputed(true);
            this.controller.showAndScrollTas(rtbPosition);
        }
        this.textShell.invalidate();
        this.textShell.validate();
        this.textShell.repaint();
    }

    public void paintTextInRGB() {
        List<Color> listOfColors = null;
        List<Integer> absoluteBeginAddresses = null;
        List<Integer> absoluteEndAddresses = null;
        List listOfFiles = null;
        listOfColors = this.controller.getListOfColors();
        absoluteBeginAddresses = this.controller.getAbsoluteBeginAddresses();
        absoluteEndAddresses = this.controller.getAbsoluteEndAddresses();
        if (absoluteBeginAddresses != null) {
            for (int i = 0; i < absoluteBeginAddresses.size(); ++i) {
                String fileName = "";
                if (listOfFiles != null) {
                    fileName = (String)listOfFiles.get(i);
                }
                if (!fileName.equals("") && !fileName.equals(this.controller.getFileToBeOpenedOrImported().getName())) continue;
                Color color = listOfColors.get(i);
                String styleString = "";
                styleString = color.equals(Constants.NOOJ_RED_BUTTON_COLOR) ? "Red" : (color.equals(Constants.NOOJ_BLUE_BUTTON_COLOR) ? "Blue" : (color.equals(Constants.NOOJ_GREEN_BUTTON_COLOR) ? "Green" : "Black"));
                int begin = absoluteBeginAddresses.get(i);
                this.doc.setCharacterAttributes(begin, absoluteEndAddresses.get(i) - begin, this.textPane.getStyle(styleString), false);
            }
        }
    }

    private int locateTextUnit(int address) {
        int tuNb;
        for (tuNb = 1; tuNb <= this.myText.nbOfTextUnits && address > this.myText.mft.tuAddresses[tuNb] + this.myText.mft.tuLengths[tuNb]; ++tuNb) {
        }
        if (tuNb <= this.myText.nbOfTextUnits) {
            return tuNb < 1 ? 1 : tuNb;
        }
        return this.myText.nbOfTextUnits < 1 ? 1 : this.myText.nbOfTextUnits;
    }

    private int correctPositionText2RtbText(Ntext myText, int textPosition, int textLength) {
        int nbN = 0;
        for (int i = textPosition; i < textPosition + textLength; ++i) {
            if (myText.buffer.charAt(i) != '\n') continue;
            ++nbN;
        }
        return textLength + nbN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void partialColorText(TextEditorShellController controller, Ntext myText, JTextPane textPane, TextEditorShell textShell, boolean currentTextUnitIsBlack) {
        try {
            CursorChangeEffect.setCustomCursor(3);
            controller.setCurrentTextUnitIsBlack(currentTextUnitIsBlack);
            boolean textWasBeingColored = controller.isTextIsBeingColored();
            controller.setTextIsBeingColored(true);
            StyledDocument doc = textPane.getStyledDocument();
            if (currentTextUnitIsBlack) {
                doc.setCharacterAttributes(0, doc.getLength(), textPane.getStyle("Inactive"), true);
                int currentTU = (Integer)textShell.getSpinner().getValue();
                int currentAddress = myText.mft.tuAddresses[currentTU];
                int correctCurrentAddress = this.correctPositionText2RtbText(myText, 0, currentAddress);
                int adjuster = 0;
                for (int i = 0; i < currentAddress; ++i) {
                    if (myText.buffer.charAt(i) != '\n') continue;
                    ++adjuster;
                }
                int currentLength = myText.mft.tuLengths[currentTU];
                doc.setCharacterAttributes(correctCurrentAddress -= adjuster, currentLength, textPane.getStyle("Active"), true);
            } else {
                doc.setCharacterAttributes(0, doc.getLength(), textPane.getStyle("Inactive"), true);
            }
            this.paintTextInRGB();
            controller.setTextIsBeingColored(textWasBeingColored);
        }
        finally {
            CursorChangeEffect.setCustomCursor(0);
        }
    }

    public void keyEventFunction(TextEditorShellController controller, KeyEvent e) {
        JTextPane textPane = controller.getTextShell().getTextPane();
        if (textPane.isEditable()) {
            return;
        }
        if (e.getKeyCode() == 127 || e.getKeyCode() == 8) {
            controller.removeAnnotation();
            return;
        }
        if (e.getKeyCode() == 155) {
            controller.addAnnotation();
            return;
        }
        if (e.getKeyCode() != 38 && e.getKeyCode() != 40 && e.getKeyCode() != 37 && e.getKeyCode() != 39) {
            return;
        }
        TuGraph tuGraph = this.textShell.getTextController().getTuGraph();
        double selectAllAnnotationsAtPosition = 0.0;
        if (this.textShell.getChckbxShowTextAnnotation().isSelected()) {
            int rtbPosition;
            String rtbText = this.textShell.getTextPane().getText();
            if (rtbPosition >= 0 && rtbPosition < rtbText.length()) {
                if (Language.isLetter(rtbText.charAt(rtbPosition))) {
                    for (rtbPosition = textPane.getCaretPosition(); rtbPosition >= 0 && Language.isLetter(rtbText.charAt(rtbPosition)); --rtbPosition) {
                    }
                    ++rtbPosition;
                }
                int currentUnit = (Integer)this.textShell.getSpinner().getValue();
                selectAllAnnotationsAtPosition = rtbPosition - this.myText.mft.tuAddresses[currentUnit];
            }
            this.textShell.getHiddenPanel().setSelectAllAnnotationsAtPosition(selectAllAnnotationsAtPosition);
            if (tuGraph.needToBeComputed) {
                Graphics g = this.textShell.getHiddenPanel().getGraphics();
                Graphics2D g2d = (Graphics2D)g;
                tuGraph.computeDrawing(this.myText.annotations, this.textShell.getHiddenPanel(), g2d);
            }
            tuGraph.computeCurrentFrameX(selectAllAnnotationsAtPosition, this.textShell.getHiddenPanel());
            tuGraph.computeXYcoord(this.textShell.getHiddenPanel(), selectAllAnnotationsAtPosition, -1);
            JButton test = new JButton(Integer.toString((int)selectAllAnnotationsAtPosition));
            test.setLocation(new Point(tuGraph.xCoord, 0));
            test.setUI(new BasicButtonUI(){

                @Override
                public void paint(Graphics g, JComponent component) {
                    int thicknessOfBorders = 3;
                    Graphics2D g2D = (Graphics2D)g;
                    JButton myButton = (JButton)component;
                    Font buttonFont = new Font(myButton.getFont().getName(), 1, myButton.getFont().getSize());
                    myButton.setFont(buttonFont);
                    myButton.setBorder(BorderFactory.createLineBorder(Color.RED, thicknessOfBorders));
                    g2D.setColor(Color.WHITE);
                    g2D.fillRoundRect(thicknessOfBorders, thicknessOfBorders, component.getWidth() - thicknessOfBorders, component.getHeight() - thicknessOfBorders, thicknessOfBorders, thicknessOfBorders);
                    super.paint(g2D, component);
                }
            });
            test.setSize(60, 20);
            this.textShell.getHiddenPanel().removeAll();
            this.textShell.getHiddenPanel().add(test);
            JScrollPane scroll = this.textShell.getPanelScrollPane();
            scroll.getVerticalScrollBar().setValue(0);
            scroll.getHorizontalScrollBar().setValue(tuGraph.xCoord);
            this.textShell.invalidate();
            this.textShell.validate();
            this.textShell.repaint();
        }
    }
}

